# LDAP Module

![Build Status](https://github.com/simplesamlphp/simplesamlphp-module-ldap/actions/workflows/php.yml/badge.svg)
[![Coverage Status](https://codecov.io/gh/simplesamlphp/simplesamlphp-module-ldap/branch/master/graph/badge.svg)](https://codecov.io/gh/simplesamlphp/simplesamlphp-module-ldap)
[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/simplesamlphp/simplesamlphp-module-ldap/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/simplesamlphp/simplesamlphp-module-ldap/?branch=master)
[![Type Coverage](https://shepherd.dev/github/simplesamlphp/simplesamlphp-module-ldap/coverage.svg)](https://shepherd.dev/github/simplesamlphp/simplesamlphp-module-ldap)
[![Psalm Level](https://shepherd.dev/github/simplesamlphp/simplesamlphp-module-ldap/level.svg)](https://shepherd.dev/github/simplesamlphp/simplesamlphp-module-ldap)

This module provides authproc-filters and authentication sources for interaction
with LDAP directories.

## Installation

Once you have installed SimpleSAMLphp, installing this module is very simple.
Just execute the following command in the root of your SimpleSAMLphp
installation:

```bash
composer.phar require simplesamlphp/simplesamlphp-module-ldap:dev-master
```

where `dev-master` instructs Composer to install the `master` branch from the
Git repository. See the [releases](https://github.com/simplesamlphp/simplesamlphp-module-ldap/releases)
available if you want to use a stable version of the module.

Next thing you need to do is to enable the module: in `config.php`,
search for the `module.enable` key and set `ldap` to true:

```php
    'module.enable' => [
         'ldap' => true,
         …
    ],
```
